/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.common.block.entity;

import cy.jdkdigital.productivebees.ProductiveBees;
import cy.jdkdigital.productivebees.common.block.entity.AbstractBlockEntity;
import cy.jdkdigital.productivebees.common.item.BeeCage;
import cy.jdkdigital.productivebees.init.ModBlockEntityTypes;
import cy.jdkdigital.productivelib.common.block.entity.InventoryHandlerHelper;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandlerModifiable;

public class JarBlockEntity
extends AbstractBlockEntity {
    @Nullable
    private Entity cachedEntity;
    public int tickCount = 0;
    private final LazyOptional<IItemHandlerModifiable> inventoryHandler = LazyOptional.of(() -> new InventoryHandlerHelper.BlockEntityItemStackHandler(1, this){

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            return stack.m_41720_().m_5456_() instanceof BeeCage && BeeCage.isFilled(stack);
        }

        public boolean isContainerItem(Item item) {
            return item instanceof BeeCage;
        }

        public boolean isInputSlot(int slot) {
            return false;
        }

        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            Level level = this.blockEntity.m_58904_();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                serverLevel.m_7260_(this.blockEntity.m_58899_(), this.blockEntity.m_58900_(), this.blockEntity.m_58900_(), 3);
            }
        }
    });

    public JarBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntityTypes.JAR.get(), pos, state);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.inventoryHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    @Nullable
    public Entity getCachedEntity(ItemStack cage) {
        if (this.cachedEntity == null) {
            this.cachedEntity = BeeCage.getCachedEntityFromStack(cage, this.m_58904_(), false);
        }
        return this.cachedEntity;
    }

    @Override
    public void savePacketNBT(CompoundTag tag) {
        super.savePacketNBT(tag);
        this.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(inv -> {
            CompoundTag compound = (CompoundTag)((INBTSerializable)inv).serializeNBT();
            tag.m_128365_("inv", (Tag)compound);
        });
    }

    @Override
    public void loadPacketNBT(CompoundTag tag) {
        super.loadPacketNBT(tag);
        CompoundTag invTag = tag.m_128469_("inv");
        this.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(inv -> ((INBTSerializable)inv).deserializeNBT((Tag)invTag));
        this.tickCount = ProductiveBees.random.m_188503_(360);
    }
}

