/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.common.item;

import cy.jdkdigital.productivebees.ProductiveBees;
import cy.jdkdigital.productivebees.common.entity.bee.ProductiveBee;
import cy.jdkdigital.productivebees.common.item.Gene;
import cy.jdkdigital.productivebees.init.ModAdvancements;
import cy.jdkdigital.productivebees.init.ModItems;
import cy.jdkdigital.productivebees.util.BeeAttribute;
import cy.jdkdigital.productivebees.util.BeeAttributes;
import cy.jdkdigital.productivebees.util.ColorUtil;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class HoneyTreat
extends Item {
    private static final String GENES_KEY = "productivebees_gene_stack";

    public HoneyTreat(Item.Properties properties) {
        super(properties);
    }

    public static boolean hasGene(ItemStack itemStack) {
        CompoundTag tag = itemStack.m_41783_();
        return !itemStack.m_41619_() && tag != null && tag.m_128441_(GENES_KEY);
    }

    public static ItemStack getTypeStack(String beeType, int value) {
        ItemStack treat = new ItemStack((ItemLike)ModItems.HONEY_TREAT.get());
        HoneyTreat.addGene(treat, Gene.getStack(beeType, value));
        return treat;
    }

    public static void addGene(ItemStack stack, ItemStack gene) {
        ListTag genes = HoneyTreat.getGenes(stack);
        boolean addedToExistingGene = false;
        for (Tag inbt : genes) {
            ItemStack insertedGene = ItemStack.m_41712_((CompoundTag)((CompoundTag)inbt));
            int purity = Gene.getPurity(insertedGene);
            if (!Gene.getAttributeName(insertedGene).equals(Gene.getAttributeName(gene)) || !Gene.getValue(insertedGene).equals(Gene.getValue(gene))) continue;
            purity = Math.min(100, purity + Gene.getPurity(gene));
            Gene.setPurity(insertedGene, purity);
            addedToExistingGene = true;
        }
        if (!addedToExistingGene) {
            CompoundTag serializedGene = gene.serializeNBT();
            genes.add((Object)serializedGene);
        }
        stack.m_41784_().m_128365_(GENES_KEY, (Tag)genes);
    }

    public static ListTag getGenes(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        ListTag genes = new ListTag();
        if (tag != null && tag.m_128423_(GENES_KEY) instanceof ListTag) {
            genes = tag.m_128423_(GENES_KEY);
        }
        return genes;
    }

    public static boolean hasBeeType(ItemStack stack) {
        ListTag genes = HoneyTreat.getGenes(stack);
        for (Tag inbt : genes) {
            ItemStack insertedGene = ItemStack.m_41712_((CompoundTag)((CompoundTag)inbt));
            BeeAttribute<Integer> existingAttribute = Gene.getAttribute(insertedGene);
            if (existingAttribute != null || Gene.getAttributeName(insertedGene).isEmpty()) continue;
            return true;
        }
        return false;
    }

    public static void applyGenesToBee(Level level, ItemStack treat, ProductiveBee bee) {
        ListTag genes = HoneyTreat.getGenes(treat);
        for (Tag inbt : genes) {
            ItemStack insertedGene = ItemStack.m_41712_((CompoundTag)((CompoundTag)inbt));
            int purity = Gene.getPurity(insertedGene);
            if (((CompoundTag)inbt).m_128441_("purity")) {
                purity = ((CompoundTag)inbt).m_128451_("purity");
            }
            if (ProductiveBees.random.m_188503_(100) > purity) continue;
            bee.setAttributeValue(Gene.getAttribute(insertedGene), Gene.getValue(insertedGene));
            level.m_46796_(2005, bee.m_20183_(), 0);
        }
    }

    public InteractionResult m_6880_(ItemStack itemStack, Player player, LivingEntity target, InteractionHand hand) {
        Bee bee;
        Level level;
        block13: {
            block12: {
                level = target.m_20193_();
                if (level.m_5776_() || !(target instanceof Bee)) break block12;
                bee = (Bee)target;
                if (target.m_6084_()) break block13;
            }
            return InteractionResult.PASS;
        }
        if (player instanceof ServerPlayer && bee.m_21660_()) {
            ModAdvancements.CALM_BEE.trigger((ServerPlayer)player, bee);
        }
        bee.m_7870_(0);
        bee.m_27915_(0);
        bee.m_5634_(bee.m_21233_());
        if (bee.m_6162_()) {
            bee.m_146740_((int)((float)(-bee.m_146764_() / 20) * 0.1f), true);
        }
        BlockPos pos = target.m_20183_();
        level.m_7106_((ParticleOptions)ParticleTypes.f_123759_, (double)pos.m_123341_(), (double)(pos.m_123342_() + 1), (double)pos.m_123343_(), 0.2, 0.1, 0.2);
        bee.m_8032_();
        if (bee instanceof ProductiveBee && !HoneyTreat.hasBeeType(itemStack)) {
            ProductiveBee productiveBee = (ProductiveBee)target;
            if (HoneyTreat.hasGene(itemStack)) {
                HoneyTreat.applyGenesToBee(level, itemStack, productiveBee);
            } else {
                int temper = productiveBee.getAttributeValue(BeeAttributes.TEMPER);
                if (temper > 0 && player.m_9236_().f_46441_.m_188501_() < 0.05f) {
                    productiveBee.getBeeAttributes().put(BeeAttributes.TEMPER, --temper);
                }
            }
        } else if (HoneyTreat.hasBeeType(itemStack)) {
            player.m_213846_((Component)Component.m_237115_((String)"productivebees.honey_treat.invalid_use"));
        }
        itemStack.m_41774_(1);
        return InteractionResult.CONSUME;
    }

    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> list, TooltipFlag flag) {
        Tag genes;
        super.m_7373_(stack, world, list, flag);
        CompoundTag tag = stack.m_41783_();
        if (tag != null && (genes = tag.m_128423_(GENES_KEY)) instanceof ListTag) {
            ((ListTag)genes).forEach(inbt -> {
                ItemStack insertedGene = ItemStack.m_41712_((CompoundTag)((CompoundTag)inbt));
                int purity = Gene.getPurity(insertedGene);
                if (((CompoundTag)inbt).m_128441_("purity")) {
                    purity = ((CompoundTag)inbt).m_128451_("purity");
                }
                Integer value = Gene.getValue(insertedGene);
                BeeAttribute<Integer> attribute = Gene.getAttribute(insertedGene);
                if (BeeAttributes.keyMap.containsKey(attribute)) {
                    MutableComponent translatedValue = Component.m_237115_((String)BeeAttributes.keyMap.get(attribute).get(value)).m_130940_(ColorUtil.getAttributeColor(value));
                    list.add((Component)Component.m_237110_((String)("productivebees.information.attribute." + Gene.getAttributeName(insertedGene)), (Object[])new Object[]{translatedValue}).m_130940_(ChatFormatting.DARK_GRAY).m_130946_(" (" + purity + "%)"));
                } else {
                    list.add((Component)Component.m_237110_((String)"productivebees.information.attribute.type", (Object[])new Object[]{Gene.getAttributeName(insertedGene)}).m_130940_(ChatFormatting.GOLD).m_130946_(" (" + purity + "%)"));
                }
            });
        }
    }
}

