/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.common.recipe;

import com.google.gson.JsonObject;
import cy.jdkdigital.productivebees.ProductiveBees;
import cy.jdkdigital.productivebees.common.item.Gene;
import cy.jdkdigital.productivebees.common.item.HoneyTreat;
import cy.jdkdigital.productivebees.init.ModItems;
import cy.jdkdigital.productivebees.init.ModRecipeTypes;
import cy.jdkdigital.productivebees.setup.BeeReloadListener;
import java.util.ArrayList;
import java.util.HashMap;
import javax.annotation.Nonnull;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class HoneyTreatGeneRecipe
implements CraftingRecipe {
    public final ResourceLocation id;
    public final ItemStack honeyTreat;

    public HoneyTreatGeneRecipe(ResourceLocation id, ItemStack honeyTreat) {
        this.id = id;
        this.honeyTreat = honeyTreat;
    }

    public CraftingBookCategory m_245232_() {
        return CraftingBookCategory.MISC;
    }

    public boolean matches(CraftingContainer inv, Level worldIn) {
        HashMap<String, Integer> addedGenes = new HashMap<String, Integer>();
        ItemStack honeyTreatStack = null;
        boolean hasAddedGenes = false;
        for (int j = 0; j < inv.m_6643_(); ++j) {
            ItemStack itemstack = inv.m_8020_(j);
            if (itemstack.m_41619_()) continue;
            if (itemstack.m_41720_().equals(ModItems.HONEY_TREAT.get()) && honeyTreatStack == null) {
                honeyTreatStack = itemstack;
                ListTag genes = HoneyTreat.getGenes(honeyTreatStack);
                for (Tag inbt : genes) {
                    ItemStack insertedGene = ItemStack.m_41712_((CompoundTag)((CompoundTag)inbt));
                    String attribute = Gene.getAttributeName(insertedGene);
                    if (addedGenes.containsKey(attribute) && !((Integer)addedGenes.get(attribute)).equals(Gene.getValue(insertedGene))) {
                        return false;
                    }
                    addedGenes.put(attribute, Gene.getValue(insertedGene));
                }
                continue;
            }
            if (itemstack.m_41720_().equals(ModItems.GENE.get())) {
                boolean isTypeGene;
                String attribute = Gene.getAttributeName(itemstack);
                boolean bl = isTypeGene = BeeReloadListener.INSTANCE.getData(attribute) != null;
                if (isTypeGene) {
                    if (addedGenes.size() > 0 && !addedGenes.containsKey(attribute)) {
                        return false;
                    }
                    addedGenes.put(attribute, Gene.getValue(itemstack));
                    hasAddedGenes = true;
                    continue;
                }
                if (addedGenes.containsKey(attribute) && !((Integer)addedGenes.get(attribute)).equals(Gene.getValue(itemstack))) {
                    return false;
                }
                addedGenes.put(attribute, Gene.getValue(itemstack));
                hasAddedGenes = true;
                continue;
            }
            return false;
        }
        if (honeyTreatStack == null) {
            return false;
        }
        return hasAddedGenes;
    }

    @Nonnull
    public ItemStack assemble(CraftingContainer inv, RegistryAccess registryAccess) {
        ItemStack treat = null;
        ArrayList<ItemStack> genes = new ArrayList<ItemStack>();
        for (int j = 0; j < inv.m_6643_(); ++j) {
            ItemStack itemstack = inv.m_8020_(j);
            if (itemstack.m_41619_()) continue;
            if (itemstack.m_41720_().equals(ModItems.HONEY_TREAT.get())) {
                treat = itemstack;
                continue;
            }
            if (!itemstack.m_41720_().equals(ModItems.GENE.get())) continue;
            genes.add(itemstack);
        }
        if (treat != null) {
            ItemStack honeyTreat = treat.m_41777_();
            genes.forEach(gene -> HoneyTreat.addGene(honeyTreat, gene));
            honeyTreat.m_41764_(1);
            return honeyTreat;
        }
        return ItemStack.f_41583_;
    }

    public boolean m_8004_(int width, int height) {
        return width >= 2 && height >= 2;
    }

    @Nonnull
    public ItemStack m_8043_(RegistryAccess registryAccess) {
        return this.honeyTreat;
    }

    @Nonnull
    public NonNullList<Ingredient> m_7527_() {
        NonNullList list = NonNullList.m_122779_();
        list.add((Object)Ingredient.m_43927_((ItemStack[])new ItemStack[]{this.honeyTreat.m_41777_()}));
        list.add((Object)Ingredient.m_43927_((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)ModItems.GENE.get())}));
        return list;
    }

    @Nonnull
    public ResourceLocation m_6423_() {
        return this.id;
    }

    @Nonnull
    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModRecipeTypes.GENE_TREAT.get();
    }

    public static class Serializer<T extends HoneyTreatGeneRecipe>
    implements RecipeSerializer<T> {
        final IRecipeFactory<T> factory;

        public Serializer(IRecipeFactory<T> factory) {
            this.factory = factory;
        }

        public T fromJson(ResourceLocation id, JsonObject json) {
            return this.factory.create(id, new ItemStack((ItemLike)ModItems.HONEY_TREAT.get()));
        }

        public T fromNetwork(@Nonnull ResourceLocation id, @Nonnull FriendlyByteBuf buffer) {
            try {
                return this.factory.create(id, buffer.m_130267_());
            }
            catch (Exception e) {
                ProductiveBees.LOGGER.error("Error reading honey treat gene recipe from packet. " + id, (Throwable)e);
                throw e;
            }
        }

        public void toNetwork(@Nonnull FriendlyByteBuf buffer, T recipe) {
            try {
                buffer.m_130055_(((HoneyTreatGeneRecipe)recipe).honeyTreat);
            }
            catch (Exception e) {
                ProductiveBees.LOGGER.error("Error writing honey treat gene recipe to packet. " + ((HoneyTreatGeneRecipe)recipe).m_6423_(), (Throwable)e);
                throw e;
            }
        }

        public static interface IRecipeFactory<T extends HoneyTreatGeneRecipe> {
            public T create(ResourceLocation var1, ItemStack var2);
        }
    }
}

