/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.datagen.recipe.provider;

import com.simibubi.create.content.processing.recipe.HeatCondition;
import com.simibubi.create.content.processing.recipe.ProcessingRecipeBuilder;
import cy.jdkdigital.productivebees.common.crafting.conditions.BeeExistsCondition;
import cy.jdkdigital.productivebees.datagen.recipe.builder.AbstractRecipeBuilder;
import cy.jdkdigital.productivebees.datagen.recipe.builder.CentrifugeRecipeBuilder;
import cy.jdkdigital.productivebees.datagen.recipe.provider.MixingRecipeGenerator;
import cy.jdkdigital.productivebees.init.ModBlocks;
import cy.jdkdigital.productivebees.init.ModFluids;
import cy.jdkdigital.productivebees.init.ModItems;
import cy.jdkdigital.productivebees.init.ModTags;
import cy.jdkdigital.productivebees.setup.HiveType;
import cy.jdkdigital.productivebees.util.BeeCreator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.data.recipes.SingleItemRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.crafting.ConditionalRecipe;
import net.minecraftforge.common.crafting.StrictNBTIngredient;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.conditions.IConditionBuilder;
import net.minecraftforge.common.crafting.conditions.ModLoadedCondition;
import net.minecraftforge.common.crafting.conditions.NotCondition;
import net.minecraftforge.common.crafting.conditions.TagEmptyCondition;
import net.minecraftforge.registries.ForgeRegistries;
import ovh.corail.woodcutter.registry.ModRecipeSerializers;

public class RecipeProvider
extends net.minecraft.data.recipes.RecipeProvider
implements IConditionBuilder {
    public RecipeProvider(PackOutput gen) {
        super(gen);
    }

    public String m_6055_() {
        return "PB Recipes";
    }

    protected void m_245200_(Consumer<FinishedRecipe> consumer) {
        MixingRecipeGenerator mixingRecipeBuilder = new MixingRecipeGenerator();
        ModBlocks.HIVELIST.forEach((modid, strings) -> strings.forEach((name, type) -> {
            name = modid.equals("productivebees") ? name : modid + "_" + name;
            this.buildHiveRecipe((String)modid, (String)name, (HiveType)type, consumer);
            this.buildBoxRecipe((String)modid, (String)name, (HiveType)type, consumer);
            if (modid.equals("productivebees")) {
                this.buildCanvasRecipes((String)name, consumer);
            }
        }));
        ModBlocks.hiveStyles.forEach(style -> {
            this.buildCanvasStonecutterRecipes((String)style, consumer);
            this.buildCanvasCorailWoodcutterRecipes((String)style, consumer);
        });
        Arrays.stream(DyeColor.values()).forEach(dyeColor -> {
            Block h = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("productivebees", dyeColor.m_7912_() + "_petrified_honey"));
            ShapelessRecipeBuilder.m_245498_((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)h).m_126209_((ItemLike)ModBlocks.PETRIFIED_HONEY.get()).m_206419_(dyeColor.getTag()).m_126132_("has_honey", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{(ItemLike)ModBlocks.PETRIFIED_HONEY.get()})).m_126140_(consumer, new ResourceLocation("productivebees", "petrified_honey/" + dyeColor.m_7912_()));
        });
        List<String> chemicals = Arrays.stream(new String[]{"actinium", "americium", "antimony", "argon", "arsenic", "astatine", "barium", "berkelium", "beryllium", "bohrium", "boron", "bromine", "cadmium", "calcium", "californium", "cerium", "cesium", "chlorine", "chromium", "copernicium", "curium", "darmstadtium", "dubnium", "dysprosium", "einsteinium", "erbium", "europium", "fermium", "flerovium", "fluorine", "francium", "gadolinium", "gallium", "germanium", "hafnium", "hassium", "helium", "holmium", "hydrogen", "indium", "iodine", "krypton", "lanthanum", "lawrencium", "lithium", "livermorium", "lutetium", "magnesium", "manganese", "meitnerium", "mendelevium", "mercury", "molybdenum", "moscovium", "neodymium", "neon", "neptunium", "nihonium", "niobium", "nitrogen", "nobelium", "oganesson", "oxygen", "palladium", "phosphorus", "plutonium", "polonium", "potassium", "praseodymium", "promethium", "protactinium", "radium", "radon", "rhenium", "rhodium", "roentgenium", "rubidium", "ruthenium", "rutherfordium", "samarium", "scandium", "seaborgium", "selenium", "silicium", "sodium", "strontium", "tantalum", "technetium", "tellurium", "tennessine", "terbium", "thallium", "thorium", "thulium", "vanadium", "xenon", "ytterbium", "yttrium", "zirconium"}).toList();
        chemicals.forEach(name -> {
            boolean isGtCompatBee = name.equals("molybdenum") || name.equals("neodymium") || name.equals("palladium");
            CentrifugeRecipeBuilder r = CentrifugeRecipeBuilder.configurable(name).addOutput(new AbstractRecipeBuilder.ModItemOutput("chemlib:" + (name.equals("silicium") ? "silicon" : name), 80)).withCondition((ICondition)new ModLoadedCondition("chemlib")).withCondition(new BeeExistsCondition("productivebees:" + name)).setFluidOutput(new AbstractRecipeBuilder.FluidOutput("productivebees:honey"));
            if (isGtCompatBee) {
                r.withCondition((ICondition)new TagEmptyCondition("forge:raw_materials/" + name));
            }
            r.m_126140_(consumer, new ResourceLocation("productivebees", "centrifuge/chemlib/honeycomb_" + name));
            ItemStack stack = new ItemStack((ItemLike)ModItems.CONFIGURABLE_HONEYCOMB.get());
            BeeCreator.setTag("productivebees:" + name, stack);
            ProcessingRecipeBuilder b = mixingRecipeBuilder.builder(new ResourceLocation("productivebees", "create/mixing/chemlib/honeycomb_" + name)).require((Ingredient)StrictNBTIngredient.of((ItemStack)stack)).output(0.8f, new ResourceLocation("chemlib:" + (name.equals("silicium") ? "silicon" : name)), 1).output((Fluid)ModFluids.HONEY.get(), 50).output((ItemLike)ModItems.WAX.get()).whenModLoaded("chemlib").whenModLoaded("create").requiresHeat(HeatCondition.HEATED);
            if (isGtCompatBee) {
                b.withCondition((ICondition)new TagEmptyCondition("forge:raw_materials/" + name));
            }
            b.build(consumer);
        });
        ArrayList<CentrifugeRecipeBuilder.RecipeConfig> ingots = new ArrayList<CentrifugeRecipeBuilder.RecipeConfig>(){
            {
                this.add(new CentrifugeRecipeBuilder.RecipeConfig("blutonium", "reactors", new String[]{"extremereactors", "biggerreactors"}, "#forge:ingots/blutonium", new HashMap<String, String>()));
                this.add(new CentrifugeRecipeBuilder.RecipeConfig("cyanite", "reactors", new String[]{"extremereactors", "biggerreactors"}, "#forge:ingots/cyanite", new HashMap<String, String>()));
                this.add(new CentrifugeRecipeBuilder.RecipeConfig("inanite", "reactors", new String[]{"extremereactors", "biggerreactors"}, "#forge:ingots/inanite", new HashMap<String, String>()));
                this.add(new CentrifugeRecipeBuilder.RecipeConfig("insanite", "reactors", new String[]{"extremereactors", "biggerreactors"}, "#forge:ingots/insanite", new HashMap<String, String>()));
                this.add(new CentrifugeRecipeBuilder.RecipeConfig("ludicrite", "reactors", new String[]{"extremereactors", "biggerreactors"}, "#forge:ingots/ludicrite", new HashMap<String, String>()));
                this.add(new CentrifugeRecipeBuilder.RecipeConfig("magentite", "reactors", new String[]{"extremereactors", "biggerreactors"}, "#forge:ingots/magentite", new HashMap<String, String>()));
                this.add(new CentrifugeRecipeBuilder.RecipeConfig("ridiculite", "reactors", new String[]{"extremereactors", "biggerreactors"}, "#forge:ingots/ridiculite", new HashMap<String, String>()));
                this.add(new CentrifugeRecipeBuilder.RecipeConfig("graphite", "reactors", new String[]{"extremereactors", "biggerreactors"}, "#forge:ingots/graphite", new HashMap<String, String>()));
            }
        };
        ingots.forEach(config -> {
            CentrifugeRecipeBuilder recipe = CentrifugeRecipeBuilder.configurable(config.name()).addOutput(new AbstractRecipeBuilder.ModItemOutput(config.centrifugeOutput())).setFluidOutput(new AbstractRecipeBuilder.FluidOutput("#forge:honey")).withCondition(new BeeExistsCondition("productivebees:" + config.name()));
            if (config.centrifugeOutput().startsWith("#")) {
                recipe.withCondition((ICondition)new NotCondition((ICondition)new TagEmptyCondition(config.centrifugeOutput().replace("#", ""))));
            }
            recipe.m_126140_(consumer, new ResourceLocation("productivebees", "centrifuge/" + config.folder() + "/honeycomb_" + config.name()));
            ItemStack stack = new ItemStack((ItemLike)ModItems.CONFIGURABLE_HONEYCOMB.get());
            BeeCreator.setTag("productivebees:" + config.name(), stack);
            Arrays.stream(config.mods()).forEach(s -> mixingRecipeBuilder.builder(new ResourceLocation("productivebees", "create/mixing/" + s + "/honeycomb_" + config.name())).require((Ingredient)StrictNBTIngredient.of((ItemStack)stack)).output(1.0f, new ResourceLocation(s + ":" + config.name()), 1).output((Fluid)ModFluids.HONEY.get(), 50).output((ItemLike)ModItems.WAX.get()).withCondition((ICondition)new BeeExistsCondition("productivebees:" + config.name())).whenModLoaded("create").whenModLoaded(s).requiresHeat(HeatCondition.HEATED).build(consumer));
        });
        List<String> gtceuBees = Arrays.stream(new String[]{"barite", "bastnasite", "bauxite", "chromite", "cobaltite", "electrotine", "galena", "graphite", "ilmenite", "lepidolite", "molybdenum", "naquadah", "neodymium", "oilsands", "palladium", "pyrochlore", "pyrolusite", "realgar", "scheelite", "sheldonite", "sphalerite", "stibnite", "tantalite", "tetrahedrite", "tricalcium_phosphate", "tungstate", "vanadium_magnetite"}).toList();
        gtceuBees.forEach(name -> {
            String resourceName = name.equals("sheldonite") ? "cooperite" : name;
            CentrifugeRecipeBuilder r = CentrifugeRecipeBuilder.configurable(name).addOutput(new AbstractRecipeBuilder.ModItemOutput("#forge:raw_materials/" + resourceName, 80)).withCondition((ICondition)new ModLoadedCondition("gtceu")).withCondition((ICondition)new NotCondition((ICondition)new TagEmptyCondition("forge:raw_materials/" + resourceName))).withCondition(new BeeExistsCondition("productivebees:gtceu/" + name)).setFluidOutput(new AbstractRecipeBuilder.FluidOutput("productivebees:honey"));
            r.m_126140_(consumer, new ResourceLocation("productivebees", "centrifuge/gtceu/honeycomb_" + name));
            ItemStack stack = new ItemStack((ItemLike)ModItems.CONFIGURABLE_HONEYCOMB.get());
            BeeCreator.setTag("productivebees:" + name, stack);
            ProcessingRecipeBuilder b = mixingRecipeBuilder.builder(new ResourceLocation("productivebees", "create/mixing/gtceu/honeycomb_" + name)).require((Ingredient)StrictNBTIngredient.of((ItemStack)stack)).output(0.8f, new ResourceLocation("gtceu:raw_" + resourceName), 1).output((Fluid)ModFluids.HONEY.get(), 50).output((ItemLike)ModItems.WAX.get()).whenModLoaded("create").whenModLoaded("gtceu").withCondition((ICondition)new BeeExistsCondition("productivebees:gtceu/" + name)).requiresHeat(HeatCondition.HEATED);
            b.build(consumer);
        });
    }

    private void buildHiveRecipe(String modid, String name, HiveType type, Consumer<FinishedRecipe> consumer) {
        Block hive = (Block)ModBlocks.HIVES.get("advanced_" + name + "_beehive").get();
        ConditionalRecipe.builder().addCondition(this.modLoaded(modid)).addRecipe(arg_0 -> ((ShapedRecipeBuilder)ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)hive).m_126145_("hives").m_126130_("WWW").m_126130_("CHC").m_126130_("FWS").m_126124_(Character.valueOf('W'), type.planks()).m_126124_(Character.valueOf('H'), Ingredient.m_204132_(ModTags.Forge.HIVES)).m_126124_(Character.valueOf('C'), Ingredient.m_204132_(ModTags.Forge.HONEYCOMBS)).m_126124_(Character.valueOf('F'), Ingredient.m_204132_(ModTags.Forge.CAMPFIRES)).m_126124_(Character.valueOf('S'), Ingredient.m_204132_((TagKey)Tags.Items.SHEARS)).m_126132_("has_hive", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{Items.f_42786_}))).m_176498_(arg_0)).build(consumer, new ResourceLocation("productivebees", "hives/advanced_" + name + "_beehive"));
        this.buildHiveResetRecipes(modid, hive, new ResourceLocation("productivebees", "hives/advanced_" + name + "_beehive_clear"), consumer);
    }

    private void buildBoxRecipe(String modid, String name, HiveType type, Consumer<FinishedRecipe> consumer) {
        Block box = (Block)ModBlocks.EXPANSIONS.get("expansion_box_" + name).get();
        ConditionalRecipe.builder().addCondition(this.modLoaded(modid)).addRecipe(arg_0 -> ((ShapedRecipeBuilder)ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)box).m_126145_("expansion_boxes").m_126130_("WWW").m_126130_("WCW").m_126130_("WWW").m_126124_(Character.valueOf('W'), type.planks()).m_126124_(Character.valueOf('C'), Ingredient.m_204132_(ModTags.Forge.HONEYCOMBS)).m_126132_("has_hive", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{Items.f_42786_}))).m_176498_(arg_0)).build(consumer, new ResourceLocation("productivebees", "expansion_boxes/expansion_box_" + name));
    }

    private void buildCanvasRecipes(String style, Consumer<FinishedRecipe> consumer) {
        Block hivein = (Block)ModBlocks.HIVES.get("advanced_" + style + "_beehive").get();
        Block hive = (Block)ModBlocks.HIVES.get("advanced_" + style + "_canvas_beehive").get();
        Block boxin = (Block)ModBlocks.EXPANSIONS.get("expansion_box_" + style).get();
        Block box = (Block)ModBlocks.EXPANSIONS.get("expansion_box_" + style + "_canvas").get();
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)hive).m_126145_("hives").m_126130_("PPP").m_126130_("PHP").m_126130_("PPP").m_126124_(Character.valueOf('H'), Ingredient.m_43929_((ItemLike[])new ItemLike[]{hivein})).m_126124_(Character.valueOf('P'), Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42516_})).m_126132_("has_hive", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{Items.f_42786_})).m_126140_(consumer, new ResourceLocation("productivebees", "hives/advanced_" + style + "_canvas_hive"));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)box).m_126145_("expansion_boxes").m_126130_("PPP").m_126130_("PHP").m_126130_("PPP").m_126124_(Character.valueOf('H'), Ingredient.m_43929_((ItemLike[])new ItemLike[]{boxin})).m_126124_(Character.valueOf('P'), Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42516_})).m_126132_("has_hive", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{Items.f_42786_})).m_126140_(consumer, new ResourceLocation("productivebees", "expansion_boxes/expansion_box_" + style + "_canvas"));
    }

    private void buildHiveResetRecipes(String modid, Block hive, ResourceLocation location, Consumer<FinishedRecipe> consumer) {
        ConditionalRecipe.builder().addCondition(this.modLoaded(modid)).addRecipe(arg_0 -> ((ShapelessRecipeBuilder)ShapelessRecipeBuilder.m_245498_((RecipeCategory)RecipeCategory.MISC, (ItemLike)hive).m_126145_("hives").m_126132_("has_hive", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{Items.f_42786_})).m_126209_((ItemLike)hive)).m_176498_(arg_0)).build(consumer, location);
    }

    private void buildCanvasStonecutterRecipes(String style, Consumer<FinishedRecipe> consumer) {
        Block hive = (Block)ModBlocks.HIVES.get("advanced_" + style + "_canvas_beehive").get();
        Block box = (Block)ModBlocks.EXPANSIONS.get("expansion_box_" + style + "_canvas").get();
        SingleItemRecipeBuilder.m_245264_((Ingredient)Ingredient.m_204132_(ModTags.CANVAS_HIVES), (RecipeCategory)RecipeCategory.MISC, (ItemLike)hive).m_126145_("hives").m_126132_("has_hive", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{Items.f_42786_})).m_126132_("has_stonecutter", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{Items.f_42776_})).m_126140_(consumer, new ResourceLocation("productivebees", "stonecutter/" + style + "_canvas_hive"));
        SingleItemRecipeBuilder.m_245264_((Ingredient)Ingredient.m_204132_(ModTags.CANVAS_BOXES), (RecipeCategory)RecipeCategory.MISC, (ItemLike)box).m_126145_("expansion_boxes").m_126132_("has_box", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{Items.f_42786_})).m_126132_("has_stonecutter", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{Items.f_42776_})).m_126140_(consumer, new ResourceLocation("productivebees", "stonecutter/" + style + "_canvas_expansion_box"));
    }

    private void buildCanvasCorailWoodcutterRecipes(String style, Consumer<FinishedRecipe> consumer) {
        Block hive = (Block)ModBlocks.HIVES.get("advanced_" + style + "_canvas_beehive").get();
        Block box = (Block)ModBlocks.EXPANSIONS.get("expansion_box_" + style + "_canvas").get();
        ConditionalRecipe.builder().addCondition(this.modLoaded("corail_woodcutter")).addRecipe(arg_0 -> ((SingleItemRecipeBuilder)RecipeProvider.woodcutter(Ingredient.m_204132_(ModTags.CANVAS_HIVES), RecipeCategory.MISC, (ItemLike)hive).m_126145_("hives").m_126132_("has_hive", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{Items.f_42786_})).m_126132_("has_woodcutter", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{Items.f_42776_}))).m_176498_(arg_0)).build(consumer, new ResourceLocation("productivebees", "corail/woodcutter/" + style + "_canvas_hive"));
        ConditionalRecipe.builder().addCondition(this.modLoaded("corail_woodcutter")).addRecipe(arg_0 -> ((SingleItemRecipeBuilder)RecipeProvider.woodcutter(Ingredient.m_204132_(ModTags.CANVAS_BOXES), RecipeCategory.MISC, (ItemLike)box).m_126145_("expansion_boxes").m_126132_("has_box", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{Items.f_42786_})).m_126132_("has_woodcutter", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{Items.f_42776_}))).m_176498_(arg_0)).build(consumer, new ResourceLocation("productivebees", "corail/woodcutter/" + style + "_canvas_expansion_box"));
    }

    public static SingleItemRecipeBuilder woodcutter(Ingredient ingredient, RecipeCategory category, ItemLike output) {
        return new SingleItemRecipeBuilder(category, ModRecipeSerializers.WOODCUTTING, ingredient, output, 1);
    }
}

