/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.api.spell;

import com.hollingsworth.arsnouveau.api.ANFakePlayer;
import com.hollingsworth.arsnouveau.api.entity.ISummon;
import com.hollingsworth.arsnouveau.api.event.SummonEvent;
import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.AbstractSpellPart;
import com.hollingsworth.arsnouveau.api.spell.EntitySpellResolver;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.api.spell.SpellStats;
import com.hollingsworth.arsnouveau.api.spell.wrapped_caster.LivingCaster;
import com.hollingsworth.arsnouveau.api.util.BlockUtil;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentAmplify;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentDurationDown;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentExtendTime;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentExtract;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentFortune;
import com.hollingsworth.arsnouveau.setup.registry.ItemsRegistry;
import com.hollingsworth.arsnouveau.setup.registry.ModPotions;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.eventbus.api.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractEffect
extends AbstractSpellPart {
    public ForgeConfigSpec.DoubleValue DAMAGE;
    public ForgeConfigSpec.DoubleValue AMP_VALUE;
    public ForgeConfigSpec.IntValue POTION_TIME;
    public ForgeConfigSpec.IntValue EXTEND_TIME;
    public ForgeConfigSpec.IntValue GENERIC_INT;
    public ForgeConfigSpec.DoubleValue GENERIC_DOUBLE;

    public AbstractEffect(String tag, String description) {
        super(tag, description);
    }

    public AbstractEffect(ResourceLocation tag, String description) {
        super(tag, description);
    }

    @Override
    public Integer getTypeIndex() {
        return 10;
    }

    public void onResolve(HitResult rayTraceResult, Level world, @NotNull LivingEntity shooter, SpellStats spellStats, SpellContext spellContext, SpellResolver resolver) {
        if (rayTraceResult instanceof BlockHitResult) {
            BlockHitResult blockHitResult = (BlockHitResult)rayTraceResult;
            this.onResolveBlock(blockHitResult, world, shooter, spellStats, spellContext, resolver);
        } else if (rayTraceResult instanceof EntityHitResult) {
            EntityHitResult entityHitResult = (EntityHitResult)rayTraceResult;
            this.onResolveEntity(entityHitResult, world, shooter, spellStats, spellContext, resolver);
        }
    }

    public void onResolveEntity(EntityHitResult rayTraceResult, Level world, @NotNull LivingEntity shooter, SpellStats spellStats, SpellContext spellContext, SpellResolver resolver) {
    }

    public void onResolveBlock(BlockHitResult rayTraceResult, Level world, @NotNull LivingEntity shooter, SpellStats spellStats, SpellContext spellContext, SpellResolver resolver) {
    }

    public boolean canSummon(LivingEntity playerEntity) {
        Player player;
        return this.isRealPlayer((Entity)playerEntity) && (playerEntity.m_21124_((MobEffect)ModPotions.SUMMONING_SICKNESS_EFFECT.get()) == null || playerEntity instanceof Player && (player = (Player)playerEntity).m_7500_());
    }

    public void applySummoningSickness(LivingEntity playerEntity, int time) {
        playerEntity.m_7292_(new MobEffectInstance((MobEffect)ModPotions.SUMMONING_SICKNESS_EFFECT.get(), time));
    }

    public void summonLivingEntity(HitResult rayTraceResult, Level world, @NotNull LivingEntity shooter, SpellStats augments, SpellContext spellContext, @Nullable SpellResolver resolver, ISummon summon) {
        LivingEntity summonLivingEntity;
        if (this.isRealPlayer((Entity)shooter)) {
            summon.setOwnerID(shooter.m_20148_());
        }
        if ((summonLivingEntity = summon.getLivingEntity()) != null) {
            world.m_7967_((Entity)summon.getLivingEntity());
            if (resolver != null && resolver.hasFocus(ItemsRegistry.SUMMONING_FOCUS.get())) {
                SpellContext newContext = resolver.spellContext.makeChildContext();
                EntitySpellResolver spellResolver = new EntitySpellResolver(newContext.withWrappedCaster(new LivingCaster(summonLivingEntity)));
                spellResolver.onResolveEffect(world, (HitResult)new EntityHitResult((Entity)summonLivingEntity));
            }
        }
        MinecraftForge.EVENT_BUS.post((Event)new SummonEvent(rayTraceResult, world, shooter, augments, spellContext, summon));
    }

    public Player getPlayer(LivingEntity entity, ServerLevel world) {
        ANFakePlayer aNFakePlayer;
        if (entity instanceof Player) {
            Player player = (Player)entity;
            aNFakePlayer = player;
        } else {
            aNFakePlayer = ANFakePlayer.getPlayer(world);
        }
        return aNFakePlayer;
    }

    public int getBaseHarvestLevel(SpellStats stats) {
        return (int)(3.0 + stats.getAmpMultiplier());
    }

    public boolean canBlockBeHarvested(SpellStats stats, Level world, BlockPos pos) {
        return BlockUtil.canBlockBeHarvested(stats, world, pos);
    }

    public Vec3 safelyGetHitPos(HitResult result) {
        Vec3 vec3;
        if (result instanceof EntityHitResult) {
            EntityHitResult entityHitResult = (EntityHitResult)result;
            vec3 = entityHitResult.m_82443_().m_20182_();
        } else {
            vec3 = result.m_82450_();
        }
        return vec3;
    }

    public boolean isRealPlayer(Entity entity) {
        return entity instanceof Player && this.isNotFakePlayer(entity);
    }

    public boolean isNotFakePlayer(Entity entity) {
        return !(entity instanceof FakePlayer);
    }

    public void applyEnchantments(SpellStats stats, ItemStack stack) {
        if (stats.hasBuff(AugmentExtract.INSTANCE)) {
            stack.m_41663_(Enchantments.f_44985_, 1);
        }
        if (stats.hasBuff(AugmentFortune.INSTANCE)) {
            stack.m_41663_(Enchantments.f_44987_, stats.getBuffCount(AugmentFortune.INSTANCE));
        }
    }

    @Override
    public void buildConfig(ForgeConfigSpec.Builder builder) {
        super.buildConfig(builder);
        HashMap<ResourceLocation, Integer> defaultAugmentLimits = new HashMap<ResourceLocation, Integer>();
        this.addDefaultAugmentLimits(defaultAugmentLimits);
        this.buildAugmentLimitsConfig(builder, defaultAugmentLimits);
        HashMap<ResourceLocation, Integer> defaultAugmentCosts = new HashMap<ResourceLocation, Integer>();
        this.addAugmentCostOverrides(defaultAugmentCosts);
        this.buildAugmentCostOverrideConfig(builder, defaultAugmentCosts);
        super.buildAugmentLimitsConfig(builder, this.getDefaultAugmentLimits(new HashMap<ResourceLocation, Integer>()));
        super.buildInvalidCombosConfig(builder, this.getDefaultInvalidCombos(new HashSet<ResourceLocation>()));
    }

    public void addDamageConfig(ForgeConfigSpec.Builder builder, double defaultValue) {
        this.DAMAGE = builder.defineInRange("damage", defaultValue, 0.0, 2.147483647E9);
    }

    public void addAmpConfig(ForgeConfigSpec.Builder builder, double defaultValue) {
        this.AMP_VALUE = builder.defineInRange("amplify", defaultValue, 0.0, 2.147483647E9);
    }

    public void addPotionConfig(ForgeConfigSpec.Builder builder, int defaultTime) {
        this.POTION_TIME = builder.comment("Potion duration, in seconds").defineInRange("potion_time", defaultTime, 0, Integer.MAX_VALUE);
    }

    public void addExtendTimeConfig(ForgeConfigSpec.Builder builder, int defaultTime) {
        this.EXTEND_TIME = builder.comment("Extend time duration, in seconds").defineInRange("extend_time", defaultTime, 0, Integer.MAX_VALUE);
    }

    public void addGenericInt(ForgeConfigSpec.Builder builder, int val, String comment, String path) {
        this.GENERIC_INT = builder.comment(comment).defineInRange(path, val, 0, Integer.MAX_VALUE);
    }

    public void addGenericDouble(ForgeConfigSpec.Builder builder, double val, String comment, String path) {
        this.GENERIC_DOUBLE = builder.comment(comment).defineInRange(path, val, 0.0, Double.MAX_VALUE);
    }

    public void addDefaultPotionConfig(ForgeConfigSpec.Builder builder) {
        this.addPotionConfig(builder, 30);
        this.addExtendTimeConfig(builder, 8);
    }

    protected Set<AbstractAugment> getPotionAugments() {
        return this.augmentSetOf(AugmentExtendTime.INSTANCE, AugmentDurationDown.INSTANCE, AugmentAmplify.INSTANCE);
    }

    protected Set<AbstractAugment> getSummonAugments() {
        return this.augmentSetOf(AugmentExtendTime.INSTANCE, AugmentDurationDown.INSTANCE);
    }
}

