/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.block;

import com.hollingsworth.arsnouveau.api.registry.RitualRegistry;
import com.hollingsworth.arsnouveau.api.util.BlockUtil;
import com.hollingsworth.arsnouveau.common.block.TickableModBlock;
import com.hollingsworth.arsnouveau.common.block.tile.RitualBrazierTile;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class RitualBrazierBlock
extends TickableModBlock {
    public static VoxelShape shape = Stream.of(Block.m_49796_((double)3.0, (double)12.0, (double)3.0, (double)13.0, (double)15.0, (double)13.0), Block.m_49796_((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)12.0, (double)10.0), Stream.of(Block.m_49796_((double)2.0, (double)14.0, (double)2.0, (double)11.0, (double)16.0, (double)5.0), Block.m_49796_((double)7.0, (double)11.0, (double)1.0, (double)9.0, (double)15.0, (double)6.0), Block.m_49796_((double)7.0, (double)0.0, (double)0.0, (double)9.0, (double)5.0, (double)4.0), Block.m_49796_((double)7.0, (double)0.0, (double)4.0, (double)9.0, (double)11.0, (double)6.0)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get(), Stream.of(Block.m_49796_((double)2.0, (double)14.0, (double)5.0, (double)5.0, (double)16.0, (double)14.0), Block.m_49796_((double)1.0, (double)11.0, (double)7.0, (double)6.0, (double)15.0, (double)9.0), Block.m_49796_((double)0.0, (double)0.0, (double)7.0, (double)4.0, (double)5.0, (double)9.0), Block.m_49796_((double)4.0, (double)0.0, (double)7.0, (double)6.0, (double)11.0, (double)9.0)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get(), Stream.of(Block.m_49796_((double)5.0, (double)14.0, (double)11.0, (double)14.0, (double)16.0, (double)14.0), Block.m_49796_((double)7.0, (double)11.0, (double)10.0, (double)9.0, (double)15.0, (double)15.0), Block.m_49796_((double)7.0, (double)0.0, (double)12.0, (double)9.0, (double)5.0, (double)16.0), Block.m_49796_((double)7.0, (double)0.0, (double)10.0, (double)9.0, (double)11.0, (double)12.0)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get(), Stream.of(Block.m_49796_((double)11.0, (double)14.0, (double)2.0, (double)14.0, (double)16.0, (double)11.0), Block.m_49796_((double)10.0, (double)11.0, (double)7.0, (double)15.0, (double)15.0, (double)9.0), Block.m_49796_((double)12.0, (double)0.0, (double)7.0, (double)16.0, (double)5.0, (double)9.0), Block.m_49796_((double)10.0, (double)0.0, (double)7.0, (double)12.0, (double)11.0, (double)9.0)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get()).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
    public static final Property<Boolean> LIT = BooleanProperty.m_61465_((String)"lit");

    public RitualBrazierBlock() {
        super(RitualBrazierBlock.defaultProperties().m_60955_().m_278166_(PushReaction.BLOCK).m_60953_(b -> (Boolean)b.m_61143_(LIT) != false ? 15 : 0));
        this.m_49959_((BlockState)this.m_49966_().m_61124_(LIT, (Comparable)Boolean.valueOf(false)));
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        RitualBrazierTile tile;
        block6: {
            block5: {
                BlockEntity blockEntity = worldIn.m_7702_(pos);
                if (!(blockEntity instanceof RitualBrazierTile)) break block5;
                tile = (RitualBrazierTile)blockEntity;
                if (handIn == InteractionHand.MAIN_HAND) break block6;
            }
            return super.m_6227_(state, worldIn, pos, player, handIn, hit);
        }
        ItemStack heldStack = player.m_21205_();
        if (heldStack.m_41619_() && tile.ritual != null && !tile.isRitualDone()) {
            tile.startRitual();
        }
        if (!heldStack.m_41619_()) {
            tile.tryBurnStack(heldStack);
        }
        return super.m_6227_(state, worldIn, pos, player, handIn, hit);
    }

    public void m_6861_(BlockState state, Level world, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        BlockEntity blockEntity;
        super.m_6861_(state, world, pos, blockIn, fromPos, isMoving);
        if (!world.m_5776_() && (blockEntity = world.m_7702_(pos)) instanceof RitualBrazierTile) {
            RitualBrazierTile tile = (RitualBrazierTile)blockEntity;
            boolean wasOff = tile.isOff;
            tile.isOff = world.m_276867_(pos);
            if (wasOff != world.m_276867_(pos) && tile.ritual != null) {
                tile.ritual.onStatusChanged(tile.isOff);
            }
            if (world.m_276867_(pos) && tile.ritual != null && tile.canRitualStart()) {
                tile.startRitual();
            }
            BlockUtil.safelyUpdateState(world, pos);
        }
    }

    public void m_5707_(Level worldIn, BlockPos pos, BlockState state, Player player) {
        super.m_5707_(worldIn, pos, state, player);
        BlockEntity blockEntity = worldIn.m_7702_(pos);
        if (blockEntity instanceof RitualBrazierTile) {
            RitualBrazierTile tile = (RitualBrazierTile)blockEntity;
            if (tile.ritual != null) {
                tile.ritual.onDestroy();
                if (!tile.ritual.isRunning() && !tile.ritual.isDone()) {
                    worldIn.m_7967_((Entity)new ItemEntity(worldIn, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), new ItemStack((ItemLike)RitualRegistry.getRitualItemMap().get(tile.ritual.getRegistryName()))));
                }
            }
        }
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{LIT});
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new RitualBrazierTile(pos, state);
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return shape;
    }

    public boolean m_7357_(BlockState pState, BlockGetter pLevel, BlockPos pPos, PathComputationType pType) {
        return false;
    }
}

