/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.spell.effect;

import com.hollingsworth.arsnouveau.api.ANFakePlayer;
import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.AbstractEffect;
import com.hollingsworth.arsnouveau.api.spell.IDamageEffect;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.api.spell.SpellSchool;
import com.hollingsworth.arsnouveau.api.spell.SpellSchools;
import com.hollingsworth.arsnouveau.api.spell.SpellStats;
import com.hollingsworth.arsnouveau.api.spell.SpellTier;
import com.hollingsworth.arsnouveau.api.util.DamageUtil;
import com.hollingsworth.arsnouveau.client.particle.ParticleUtil;
import com.hollingsworth.arsnouveau.common.entity.IceShardEntity;
import com.hollingsworth.arsnouveau.common.items.curios.ShapersFocus;
import com.hollingsworth.arsnouveau.common.lib.GlyphLib;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentAOE;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentAmplify;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentDampen;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentDurationDown;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentExtendTime;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentFortune;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentRandomize;
import com.hollingsworth.arsnouveau.setup.registry.DamageTypesRegistry;
import com.hollingsworth.arsnouveau.setup.registry.ModPotions;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeConfigSpec;
import org.jetbrains.annotations.NotNull;

public class EffectColdSnap
extends AbstractEffect
implements IDamageEffect {
    public static EffectColdSnap INSTANCE = new EffectColdSnap();

    private EffectColdSnap() {
        super(GlyphLib.EffectColdSnapID, "Cold Snap");
    }

    @Override
    public void onResolveEntity(EntityHitResult rayTraceResult, Level world, @NotNull LivingEntity shooter, SpellStats spellStats, SpellContext spellContext, SpellResolver resolver) {
        LivingEntity livingEntity;
        block6: {
            block5: {
                Entity entity = rayTraceResult.m_82443_();
                if (!(entity instanceof LivingEntity)) break block5;
                livingEntity = (LivingEntity)entity;
                if (world instanceof ServerLevel) break block6;
            }
            return;
        }
        ServerLevel level = (ServerLevel)world;
        Vec3 vec = this.safelyGetHitPos((HitResult)rayTraceResult);
        float damage = (float)((Double)this.DAMAGE.get() + (Double)this.AMP_VALUE.get() * spellStats.getAmpMultiplier());
        int snareSec = (int)((double)((Integer)this.POTION_TIME.get()).intValue() + (double)((Integer)this.EXTEND_TIME.get()).intValue() * spellStats.getDurationMultiplier());
        if (!this.canDamage(livingEntity)) {
            return;
        }
        this.damage(vec, level, shooter, livingEntity, spellStats, spellContext, resolver, snareSec, damage);
        this.spawnIce(shooter, (Level)level, BlockPos.m_274561_((double)vec.f_82479_, (double)(vec.f_82480_ + (double)(rayTraceResult.m_82443_().m_20096_() ? 1 : 0)), (double)vec.f_82481_), spellStats, spellContext, resolver);
        if (livingEntity.m_21023_((MobEffect)ModPotions.FREEZING_EFFECT.get())) {
            livingEntity.m_146917_(livingEntity.m_146891_() + 3);
        }
    }

    @Override
    public void onResolveBlock(BlockHitResult rayTraceResult, Level world, @NotNull LivingEntity shooter, SpellStats spellStats, SpellContext spellContext, SpellResolver resolver) {
        super.onResolveBlock(rayTraceResult, world, shooter, spellStats, spellContext, resolver);
        if (!world.m_8055_(rayTraceResult.m_82425_()).m_204336_(BlockTags.f_13047_)) {
            return;
        }
        world.m_7731_(rayTraceResult.m_82425_(), Blocks.f_50016_.m_49966_(), 3);
        this.spawnIce(shooter, world, rayTraceResult.m_82425_(), spellStats, spellContext, resolver);
    }

    public void spawnIce(LivingEntity shooter, Level level, BlockPos targetPos, SpellStats spellStats, SpellContext spellContext, SpellResolver resolver) {
        Vec3 middleVec = new Vec3(0.2, 0.3, 0.2);
        Vec3 cornerScaleVec = new Vec3(0.1, 0.2, 0.1);
        HashSet<BlockPos> corners = new HashSet<BlockPos>();
        HashSet<BlockPos> sides = new HashSet<BlockPos>();
        int i = 1;
        while ((double)i < 2.0 + spellStats.getAoeMultiplier()) {
            sides.addAll(this.replaceableBetween(level, targetPos.m_7918_(-i, -i, 0), targetPos.m_7918_(-i, i, 0)));
            sides.addAll(this.replaceableBetween(level, targetPos.m_7918_(i, -i, 0), targetPos.m_7918_(i, i, 0)));
            sides.addAll(this.replaceableBetween(level, targetPos.m_7918_(0, -i, -i), targetPos.m_7918_(0, i, -i)));
            sides.addAll(this.replaceableBetween(level, targetPos.m_7918_(0, -i, i), targetPos.m_7918_(0, i, i)));
            corners.addAll(this.replaceableBetween(level, targetPos.m_7918_(-i, -i, -i), targetPos.m_7918_(-i, i, -i)));
            corners.addAll(this.replaceableBetween(level, targetPos.m_7918_(i, -i, -i), targetPos.m_7918_(i, i, -i)));
            corners.addAll(this.replaceableBetween(level, targetPos.m_7918_(-i, -i, i), targetPos.m_7918_(-i, i, i)));
            corners.addAll(this.replaceableBetween(level, targetPos.m_7918_(i, -i, i), targetPos.m_7918_(i, i, i)));
            ++i;
        }
        corners.addAll(this.replaceableBetween(level, targetPos.m_7918_(0, -1, 0), targetPos.m_7918_(0, 1, 0)));
        for (BlockPos pos : corners) {
            if (!level.m_8055_(pos).m_247087_()) continue;
            this.spawnIce(level, pos, targetPos, cornerScaleVec, spellStats, spellContext, resolver, shooter);
        }
        for (BlockPos pos : sides) {
            if (!level.m_8055_(pos).m_247087_()) continue;
            this.spawnIce(level, pos, targetPos, middleVec, spellStats, spellContext, resolver, shooter);
        }
    }

    public void spawnIce(Level level, BlockPos pos, BlockPos targetPos, Vec3 scaleVec, SpellStats spellStats, SpellContext context, SpellResolver resolver, LivingEntity shooter) {
        level.m_7731_(pos, Blocks.f_50016_.m_49966_(), 3);
        IceShardEntity fallingBlock = new IceShardEntity(level, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_(), (double)pos.m_123343_() + 0.5, Blocks.f_50126_.m_49966_());
        fallingBlock.m_20334_(pos.m_123341_() - targetPos.m_123341_(), pos.m_123342_() - targetPos.m_123342_(), pos.m_123343_() - targetPos.m_123343_());
        fallingBlock.m_20256_(fallingBlock.m_20184_().m_82559_(scaleVec));
        fallingBlock.cancelDrop = true;
        fallingBlock.dropItem = false;
        fallingBlock.hurtEntities = true;
        fallingBlock.baseDamage = (float)((Double)this.DAMAGE.get() + (Double)this.AMP_VALUE.get() * spellStats.getAmpMultiplier()) * 0.5f;
        fallingBlock.shooter = shooter;
        level.m_7967_((Entity)fallingBlock);
        ShapersFocus.tryPropagateEntitySpell(fallingBlock, level, shooter, context, resolver);
    }

    public Set<BlockPos> replaceableBetween(Level level, BlockPos pos1, BlockPos pos2) {
        HashSet<BlockPos> set = new HashSet<BlockPos>();
        for (BlockPos pos : BlockPos.m_121940_((BlockPos)pos1, (BlockPos)pos2)) {
            if (!level.m_8055_(pos).m_247087_()) continue;
            set.add(pos.m_7949_());
        }
        return set;
    }

    public boolean canDamage(LivingEntity livingEntity) {
        return livingEntity.m_20070_() || livingEntity.m_21023_(MobEffects.f_19597_) || (double)livingEntity.m_146889_() > 0.0;
    }

    public void damage(Vec3 vec, ServerLevel world, LivingEntity shooter, LivingEntity livingEntity, SpellStats stats, SpellContext context, SpellResolver resolver, int snareTime, float damage) {
        if (this.attemptDamage((Level)world, shooter, stats, context, resolver, (Entity)livingEntity, this.buildDamageSource((Level)world, shooter), damage)) {
            world.m_8767_((ParticleOptions)ParticleTypes.f_123764_, vec.f_82479_, vec.f_82480_ + 0.5, vec.f_82481_, 50, ParticleUtil.inRange(-0.1, 0.1), ParticleUtil.inRange(-0.1, 0.1), ParticleUtil.inRange(-0.1, 0.1), 0.3);
            livingEntity.m_7292_(new MobEffectInstance((MobEffect)ModPotions.SNARE_EFFECT.get(), 20 * snareTime));
        }
    }

    @Override
    public DamageSource buildDamageSource(Level world, LivingEntity shooter) {
        return DamageUtil.source((LevelAccessor)world, DamageTypesRegistry.COLD_SNAP, (Entity)(shooter == null ? ANFakePlayer.getPlayer((ServerLevel)world) : shooter));
    }

    @Override
    public void buildConfig(ForgeConfigSpec.Builder builder) {
        super.buildConfig(builder);
        this.addDamageConfig(builder, 6.0);
        this.addAmpConfig(builder, 2.5);
        this.addPotionConfig(builder, 5);
        this.addExtendTimeConfig(builder, 1);
    }

    @Override
    protected void addDefaultAugmentLimits(Map<ResourceLocation, Integer> defaults) {
        defaults.put(AugmentAmplify.INSTANCE.getRegistryName(), 2);
        defaults.put(AugmentAOE.INSTANCE.getRegistryName(), 1);
    }

    @Override
    public int getDefaultManaCost() {
        return 30;
    }

    @Override
    @NotNull
    public Set<AbstractAugment> getCompatibleAugments() {
        return this.augmentSetOf(AugmentAmplify.INSTANCE, AugmentDampen.INSTANCE, AugmentExtendTime.INSTANCE, AugmentDurationDown.INSTANCE, AugmentAOE.INSTANCE, AugmentFortune.INSTANCE, AugmentRandomize.INSTANCE);
    }

    @Override
    public String getBookDescription() {
        return "Causes wet, slowed, or freezing entities to take a burst of damage and erupt into falling ice. Falling ice will slow and damage nearby entities. Can also be used to erupt a block of ice instead. Falling blocks of ice can be manipulated with the Focus of Block Shaping. Entities afflicted with Freezing will be set to the maximum freeze level immediately.";
    }

    @Override
    public SpellTier defaultTier() {
        return SpellTier.TWO;
    }

    @Override
    @NotNull
    public Set<SpellSchool> getSchools() {
        return this.setOf(SpellSchools.ELEMENTAL_WATER);
    }
}

