/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.data.resources.registries;

import com.aetherteam.aether.AetherConfig;
import com.aetherteam.aether.block.AetherBlocks;
import com.aetherteam.aether.data.resources.builders.AetherPlacedFeatureBuilders;
import com.aetherteam.aether.data.resources.registries.AetherConfiguredFeatures;
import com.aetherteam.aether.world.placementmodifier.ConfigFilter;
import com.aetherteam.aether.world.placementmodifier.DungeonBlacklistFilter;
import com.aetherteam.aether.world.placementmodifier.HolidayFilter;
import com.aetherteam.aether.world.placementmodifier.ImprovedLayerPlacementModifier;
import com.aetherteam.nitrogen.data.resources.builders.NitrogenPlacedFeatureBuilders;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.data.worldgen.features.VegetationFeatures;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.CountPlacement;
import net.minecraft.world.level.levelgen.placement.HeightRangePlacement;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.NoiseThresholdCountPlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.RarityFilter;
import net.minecraft.world.level.levelgen.placement.SurfaceWaterDepthFilter;

public class AetherPlacedFeatures {
    public static final ResourceKey<PlacedFeature> COLD_AERCLOUD_PLACEMENT = AetherPlacedFeatures.createKey("cold_aercloud");
    public static final ResourceKey<PlacedFeature> BLUE_AERCLOUD_PLACEMENT = AetherPlacedFeatures.createKey("blue_aercloud");
    public static final ResourceKey<PlacedFeature> GOLDEN_AERCLOUD_PLACEMENT = AetherPlacedFeatures.createKey("golden_aercloud");
    public static final ResourceKey<PlacedFeature> SKYROOT_MEADOW_TREES_PLACEMENT = AetherPlacedFeatures.createKey("skyroot_meadow_trees");
    public static final ResourceKey<PlacedFeature> SKYROOT_GROVE_TREES_PLACEMENT = AetherPlacedFeatures.createKey("skyroot_grove_trees");
    public static final ResourceKey<PlacedFeature> SKYROOT_WOODLAND_TREES_PLACEMENT = AetherPlacedFeatures.createKey("skyroot_woodland_trees");
    public static final ResourceKey<PlacedFeature> SKYROOT_FOREST_TREES_PLACEMENT = AetherPlacedFeatures.createKey("skyroot_forest_trees");
    public static final ResourceKey<PlacedFeature> CRYSTAL_ISLAND_PLACEMENT = AetherPlacedFeatures.createKey("crystal_island");
    public static final ResourceKey<PlacedFeature> HOLIDAY_TREE_PLACEMENT = AetherPlacedFeatures.createKey("holiday_tree");
    public static final ResourceKey<PlacedFeature> GRASS_PATCH_PLACEMENT = AetherPlacedFeatures.createKey("grass_patch");
    public static final ResourceKey<PlacedFeature> TALL_GRASS_PATCH_PLACEMENT = AetherPlacedFeatures.createKey("tall_grass_patch");
    public static final ResourceKey<PlacedFeature> AETHER_GRASS_BONEMEAL = AetherPlacedFeatures.createKey("aether_grass_bonemeal");
    public static final ResourceKey<PlacedFeature> WHITE_FLOWER_PATCH_PLACEMENT = AetherPlacedFeatures.createKey("white_flower_patch");
    public static final ResourceKey<PlacedFeature> PURPLE_FLOWER_PATCH_PLACEMENT = AetherPlacedFeatures.createKey("purple_flower_patch");
    public static final ResourceKey<PlacedFeature> BERRY_BUSH_PATCH_PLACEMENT = AetherPlacedFeatures.createKey("berry_bush_patch");
    public static final ResourceKey<PlacedFeature> QUICKSOIL_SHELF_PLACEMENT = AetherPlacedFeatures.createKey("quicksoil_shelf");
    public static final ResourceKey<PlacedFeature> WATER_LAKE_PLACEMENT = AetherPlacedFeatures.createKey("water_lake");
    public static final ResourceKey<PlacedFeature> WATER_SPRING_PLACEMENT = AetherPlacedFeatures.createKey("water_spring");
    public static final ResourceKey<PlacedFeature> ORE_AETHER_DIRT_PLACEMENT = AetherPlacedFeatures.createKey("aether_dirt_ore");
    public static final ResourceKey<PlacedFeature> ORE_ICESTONE_PLACEMENT = AetherPlacedFeatures.createKey("icestone_ore");
    public static final ResourceKey<PlacedFeature> ORE_AMBROSIUM_PLACEMENT = AetherPlacedFeatures.createKey("ambrosium_ore");
    public static final ResourceKey<PlacedFeature> ORE_ZANITE_PLACEMENT = AetherPlacedFeatures.createKey("zanite_ore");
    public static final ResourceKey<PlacedFeature> ORE_GRAVITITE_BURIED_PLACEMENT = AetherPlacedFeatures.createKey("gravitite_ore_buried");
    public static final ResourceKey<PlacedFeature> ORE_GRAVITITE_PLACEMENT = AetherPlacedFeatures.createKey("gravitite_ore");

    private static ResourceKey<PlacedFeature> createKey(String name) {
        return ResourceKey.m_135785_((ResourceKey)Registries.f_256988_, (ResourceLocation)new ResourceLocation("aether", name));
    }

    public static void bootstrap(BootstapContext<PlacedFeature> context) {
        HolderGetter configuredFeatures = context.m_255420_(Registries.f_256911_);
        AetherPlacedFeatures.register(context, COLD_AERCLOUD_PLACEMENT, configuredFeatures.m_255043_(AetherConfiguredFeatures.COLD_AERCLOUD_CONFIGURATION), AetherPlacedFeatureBuilders.aercloudPlacement(32, 64, 7));
        AetherPlacedFeatures.register(context, BLUE_AERCLOUD_PLACEMENT, configuredFeatures.m_255043_(AetherConfiguredFeatures.BLUE_AERCLOUD_CONFIGURATION), AetherPlacedFeatureBuilders.aercloudPlacement(32, 64, 24));
        AetherPlacedFeatures.register(context, GOLDEN_AERCLOUD_PLACEMENT, configuredFeatures.m_255043_(AetherConfiguredFeatures.GOLDEN_AERCLOUD_CONFIGURATION), AetherPlacedFeatureBuilders.aercloudPlacement(96, 32, 75));
        AetherPlacedFeatures.register(context, CRYSTAL_ISLAND_PLACEMENT, configuredFeatures.m_255043_(AetherConfiguredFeatures.CRYSTAL_ISLAND_CONFIGURATION), new PlacementModifier[]{RarityFilter.m_191900_((int)50), InSquarePlacement.m_191715_(), HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158922_((int)32), (VerticalAnchor)VerticalAnchor.m_158922_((int)96)), BiomeFilter.m_191561_(), new DungeonBlacklistFilter()});
        AetherPlacedFeatures.register(context, SKYROOT_MEADOW_TREES_PLACEMENT, configuredFeatures.m_255043_(AetherConfiguredFeatures.TREES_SKYROOT_AND_GOLDEN_OAK_CONFIGURATION), AetherPlacedFeatureBuilders.treePlacement((PlacementModifier)RarityFilter.m_191900_((int)1)));
        AetherPlacedFeatures.register(context, SKYROOT_GROVE_TREES_PLACEMENT, configuredFeatures.m_255043_(AetherConfiguredFeatures.TREES_SKYROOT_AND_GOLDEN_OAK_CONFIGURATION), AetherPlacedFeatureBuilders.treePlacement(PlacementUtils.m_195364_((int)2, (float)0.1f, (int)1)));
        AetherPlacedFeatures.register(context, SKYROOT_WOODLAND_TREES_PLACEMENT, configuredFeatures.m_255043_(AetherConfiguredFeatures.TREES_SKYROOT_AND_GOLDEN_OAK_CONFIGURATION), AetherPlacedFeatureBuilders.treePlacement(PlacementUtils.m_195364_((int)5, (float)0.1f, (int)1)));
        AetherPlacedFeatures.register(context, SKYROOT_FOREST_TREES_PLACEMENT, configuredFeatures.m_255043_(AetherConfiguredFeatures.TREES_SKYROOT_AND_GOLDEN_OAK_CONFIGURATION), AetherPlacedFeatureBuilders.treePlacement(PlacementUtils.m_195364_((int)6, (float)0.1f, (int)1)));
        AetherPlacedFeatures.register(context, HOLIDAY_TREE_PLACEMENT, configuredFeatures.m_255043_(AetherConfiguredFeatures.HOLIDAY_TREE_CONFIGURATION), new PlacementModifier[]{RarityFilter.m_191900_((int)75), InSquarePlacement.m_191715_(), SurfaceWaterDepthFilter.m_191950_((int)0), PlacementUtils.f_195355_, BiomeFilter.m_191561_(), new HolidayFilter(), PlacementUtils.m_206493_((Block)((Block)AetherBlocks.SKYROOT_SAPLING.get()))});
        AetherPlacedFeatures.register(context, GRASS_PATCH_PLACEMENT, configuredFeatures.m_255043_(AetherConfiguredFeatures.GRASS_PATCH_CONFIGURATION), new PlacementModifier[]{NoiseThresholdCountPlacement.m_191756_((double)-0.8, (int)5, (int)10), ImprovedLayerPlacementModifier.of(Heightmap.Types.MOTION_BLOCKING, (IntProvider)UniformInt.m_146622_((int)0, (int)1), 4), BiomeFilter.m_191561_(), new ConfigFilter(AetherConfig.SERVER.generate_tall_grass)});
        AetherPlacedFeatures.register(context, AETHER_GRASS_BONEMEAL, configuredFeatures.m_255043_(VegetationFeatures.f_195184_), new PlacementModifier[]{PlacementUtils.m_206517_()});
        AetherPlacedFeatures.register(context, TALL_GRASS_PATCH_PLACEMENT, configuredFeatures.m_255043_(AetherConfiguredFeatures.TALL_GRASS_PATCH_CONFIGURATION), new PlacementModifier[]{NoiseThresholdCountPlacement.m_191756_((double)-0.8, (int)0, (int)7), RarityFilter.m_191900_((int)32), ImprovedLayerPlacementModifier.of(Heightmap.Types.MOTION_BLOCKING, (IntProvider)UniformInt.m_146622_((int)0, (int)1), 4), BiomeFilter.m_191561_(), new ConfigFilter(AetherConfig.SERVER.generate_tall_grass)});
        AetherPlacedFeatures.register(context, WHITE_FLOWER_PATCH_PLACEMENT, configuredFeatures.m_255043_(AetherConfiguredFeatures.WHITE_FLOWER_PATCH_CONFIGURATION), new PlacementModifier[]{RarityFilter.m_191900_((int)8), ImprovedLayerPlacementModifier.of(Heightmap.Types.MOTION_BLOCKING, (IntProvider)UniformInt.m_146622_((int)0, (int)1), 4), BiomeFilter.m_191561_()});
        AetherPlacedFeatures.register(context, PURPLE_FLOWER_PATCH_PLACEMENT, configuredFeatures.m_255043_(AetherConfiguredFeatures.PURPLE_FLOWER_PATCH_CONFIGURATION), new PlacementModifier[]{RarityFilter.m_191900_((int)16), ImprovedLayerPlacementModifier.of(Heightmap.Types.MOTION_BLOCKING, (IntProvider)UniformInt.m_146622_((int)0, (int)1), 4), BiomeFilter.m_191561_()});
        AetherPlacedFeatures.register(context, BERRY_BUSH_PATCH_PLACEMENT, configuredFeatures.m_255043_(AetherConfiguredFeatures.BERRY_BUSH_PATCH_CONFIGURATION), new PlacementModifier[]{RarityFilter.m_191900_((int)8), ImprovedLayerPlacementModifier.of(Heightmap.Types.MOTION_BLOCKING, (IntProvider)UniformInt.m_146622_((int)0, (int)1), 4), BiomeFilter.m_191561_()});
        AetherPlacedFeatures.register(context, QUICKSOIL_SHELF_PLACEMENT, configuredFeatures.m_255043_(AetherConfiguredFeatures.QUICKSOIL_SHELF_CONFIGURATION), new PlacementModifier[]{RarityFilter.m_191900_((int)5), PlacementUtils.f_195354_, BiomeFilter.m_191561_(), new DungeonBlacklistFilter()});
        AetherPlacedFeatures.register(context, WATER_LAKE_PLACEMENT, configuredFeatures.m_255043_(AetherConfiguredFeatures.WATER_LAKE_CONFIGURATION), new PlacementModifier[]{RarityFilter.m_191900_((int)15), PlacementUtils.f_195354_, BiomeFilter.m_191561_()});
        AetherPlacedFeatures.register(context, WATER_SPRING_PLACEMENT, configuredFeatures.m_255043_(AetherConfiguredFeatures.WATER_SPRING_CONFIGURATION), new PlacementModifier[]{CountPlacement.m_191628_((int)30), InSquarePlacement.m_191715_(), HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158930_((int)8), (VerticalAnchor)VerticalAnchor.m_158930_((int)128)), BiomeFilter.m_191561_(), new DungeonBlacklistFilter()});
        AetherPlacedFeatures.register(context, ORE_AETHER_DIRT_PLACEMENT, configuredFeatures.m_255043_(AetherConfiguredFeatures.ORE_AETHER_DIRT_CONFIGURATION), NitrogenPlacedFeatureBuilders.commonOrePlacement((int)20, (PlacementModifier)HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158921_(), (VerticalAnchor)VerticalAnchor.m_158930_((int)128))));
        AetherPlacedFeatures.register(context, ORE_ICESTONE_PLACEMENT, configuredFeatures.m_255043_(AetherConfiguredFeatures.ORE_ICESTONE_CONFIGURATION), NitrogenPlacedFeatureBuilders.commonOrePlacement((int)10, (PlacementModifier)HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158921_(), (VerticalAnchor)VerticalAnchor.m_158930_((int)128))));
        AetherPlacedFeatures.register(context, ORE_AMBROSIUM_PLACEMENT, configuredFeatures.m_255043_(AetherConfiguredFeatures.ORE_AMBROSIUM_CONFIGURATION), NitrogenPlacedFeatureBuilders.commonOrePlacement((int)20, (PlacementModifier)HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158921_(), (VerticalAnchor)VerticalAnchor.m_158930_((int)128))));
        AetherPlacedFeatures.register(context, ORE_ZANITE_PLACEMENT, configuredFeatures.m_255043_(AetherConfiguredFeatures.ORE_ZANITE_CONFIGURATION), NitrogenPlacedFeatureBuilders.commonOrePlacement((int)14, (PlacementModifier)HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158921_(), (VerticalAnchor)VerticalAnchor.m_158930_((int)75))));
        AetherPlacedFeatures.register(context, ORE_GRAVITITE_BURIED_PLACEMENT, configuredFeatures.m_255043_(AetherConfiguredFeatures.ORE_GRAVITITE_BURIED_CONFIGURATION), NitrogenPlacedFeatureBuilders.commonOrePlacement((int)5, (PlacementModifier)HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158921_(), (VerticalAnchor)VerticalAnchor.m_158930_((int)74))));
        AetherPlacedFeatures.register(context, ORE_GRAVITITE_PLACEMENT, configuredFeatures.m_255043_(AetherConfiguredFeatures.ORE_GRAVITITE_CONFIGURATION), NitrogenPlacedFeatureBuilders.commonOrePlacement((int)7, (PlacementModifier)HeightRangePlacement.m_191692_((VerticalAnchor)VerticalAnchor.m_158930_((int)-58), (VerticalAnchor)VerticalAnchor.m_158930_((int)74))));
    }

    private static void register(BootstapContext<PlacedFeature> context, ResourceKey<PlacedFeature> key, Holder<ConfiguredFeature<?, ?>> configuration, List<PlacementModifier> modifiers) {
        context.m_255272_(key, (Object)new PlacedFeature(configuration, List.copyOf(modifiers)));
    }

    private static void register(BootstapContext<PlacedFeature> context, ResourceKey<PlacedFeature> key, Holder<ConfiguredFeature<?, ?>> configuration, PlacementModifier ... modifiers) {
        AetherPlacedFeatures.register(context, key, configuration, List.of(modifiers));
    }
}

