/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.world.structurepiece.bronzedungeon;

import com.aetherteam.aether.AetherTags;
import com.aetherteam.aether.world.BlockLogicUtil;
import com.aetherteam.aether.world.structurepiece.bronzedungeon.BronzeBossRoom;
import com.aetherteam.aether.world.structurepiece.bronzedungeon.BronzeDungeonRoom;
import com.aetherteam.aether.world.structurepiece.bronzedungeon.BronzeTunnel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.NoiseColumn;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;

public class BronzeDungeonBuilder {
    private final Structure.GenerationContext context;
    private final StructureTemplateManager manager;
    private final RandomSource random;
    private final int nodeWidth;
    private final int edgeWidth;
    private final int edgeLength;
    private final int maxSize;
    private final List<StructurePiece> nodes = new ArrayList<StructurePiece>();
    private final Map<StructurePiece, Map<Direction, Connection>> edges = new HashMap<StructurePiece, Map<Direction, Connection>>();

    public BronzeDungeonBuilder(Structure.GenerationContext context, int maxSize) {
        this.context = context;
        this.manager = context.f_226625_();
        this.random = context.f_226626_();
        Vec3i nodeSize = context.f_226625_().m_230359_(new ResourceLocation("aether", "bronze_dungeon/chest_room")).m_163801_();
        this.nodeWidth = nodeSize.m_123341_();
        Vec3i edgeSize = context.f_226625_().m_230359_(new ResourceLocation("aether", "bronze_dungeon/square_tunnel")).m_163801_();
        this.edgeWidth = edgeSize.m_123341_();
        this.edgeLength = edgeSize.m_123343_();
        this.maxSize = Math.max(3, maxSize);
    }

    public void initializeDungeon(BlockPos startPos, ChunkPos chunkPos, StructurePiecesBuilder builder) {
        StructureTemplate bossTemplate = this.context.f_226625_().m_230359_(new ResourceLocation("aether", "bronze_dungeon/boss_room"));
        Rotation rotation = this.getBossRoomRotation(startPos, startPos.m_121955_(bossTemplate.m_163801_()));
        if (rotation == null) {
            return;
        }
        BronzeBossRoom bossRoom = new BronzeBossRoom(this.manager, "boss_room", startPos, rotation);
        Direction direction = bossRoom.m_73549_();
        if (direction != null) {
            BlockPos pos = BlockLogicUtil.tunnelFromEvenSquareRoom(bossRoom.m_73547_().m_71045_(0, 2, 0), direction, this.edgeWidth);
            BronzeDungeonRoom hallway = new BronzeDungeonRoom(this.manager, "square_tunnel", pos, bossRoom.m_6830_());
            pos = BlockLogicUtil.tunnelFromEvenSquareRoom(hallway.m_73547_(), direction, this.nodeWidth);
            BronzeDungeonRoom chestRoom = new BronzeDungeonRoom(this.manager, "chest_room", pos, hallway.m_6830_());
            this.nodes.add((StructurePiece)bossRoom);
            this.nodes.add((StructurePiece)chestRoom);
            new Connection((StructurePiece)bossRoom, (StructurePiece)chestRoom, (StructurePiece)hallway, direction);
            for (int i = 2; i < this.maxSize - 1; ++i) {
                this.propagateRooms((StructurePiece)chestRoom, chunkPos, false);
            }
            this.propagateRooms((StructurePiece)chestRoom, chunkPos, true);
            StructurePiece lobby = this.nodes.get(this.nodes.size() - 1);
            this.buildEndTunnel(lobby, startPos);
            this.populatePiecesBuilder(builder);
        }
    }

    private boolean propagateRooms(StructurePiece currentNode, ChunkPos chunkPos, boolean placeLobby) {
        Rotation rotation = currentNode.m_6830_();
        ArrayList<Rotation> rotations = new ArrayList<Rotation>(3);
        rotations.add(rotation.m_55952_(Rotation.COUNTERCLOCKWISE_90));
        rotations.add(rotation);
        rotations.add(rotation.m_55952_(Rotation.CLOCKWISE_90));
        String roomName = placeLobby ? "lobby" : "chest_room";
        for (int i = 3; i > 0; --i) {
            boolean flag;
            rotation = (Rotation)rotations.remove(this.random.m_188503_(i));
            Direction direction = rotation.m_55954_(Direction.SOUTH);
            if (this.hasConnection(currentNode, direction)) {
                if (!this.propagateRooms(this.edges.get((Object)currentNode).get((Object)direction).end, chunkPos, placeLobby)) continue;
                return true;
            }
            BlockPos pos = BlockLogicUtil.tunnelFromEvenSquareRoom(currentNode.m_73547_(), direction, this.edgeWidth);
            BronzeDungeonRoom hallway = new BronzeDungeonRoom(this.manager, "square_tunnel", pos, rotation);
            pos = BlockLogicUtil.tunnelFromEvenSquareRoom(hallway.m_73547_(), direction, this.nodeWidth);
            BronzeDungeonRoom room = new BronzeDungeonRoom(this.manager, roomName, pos, rotation);
            StructurePiece collisionPiece = StructurePiece.m_192648_(this.nodes, (BoundingBox)room.m_73547_());
            if (!this.isCloseToCenter(chunkPos, room.m_226912_()) || !this.isCoveredAtPos(room.m_73547_())) continue;
            if (collisionPiece == null) {
                new Connection(currentNode, (StructurePiece)room, (StructurePiece)hallway, direction);
                this.nodes.add((StructurePiece)room);
                return true;
            }
            if (collisionPiece instanceof BronzeBossRoom || (flag = this.edges.computeIfAbsent(collisionPiece, piece -> new HashMap()).values().stream().map(Connection::endPiece).anyMatch(piece -> piece == currentNode))) continue;
            new Connection(currentNode, (StructurePiece)room, (StructurePiece)hallway, direction);
        }
        return false;
    }

    private void buildEndTunnel(StructurePiece lobby, BlockPos origin) {
        Rotation rotation = lobby.m_6830_();
        ArrayList<Rotation> rotations = new ArrayList<Rotation>(3);
        rotations.add(rotation.m_55952_(Rotation.COUNTERCLOCKWISE_90));
        rotations.add(rotation);
        rotations.add(rotation.m_55952_(Rotation.CLOCKWISE_90));
        ArrayList<StructurePiece> longestTunnel = null;
        for (int i = 3; i > 0; --i) {
            Direction direction;
            ArrayList<StructurePiece> tunnel = new ArrayList<StructurePiece>();
            rotation = (Rotation)rotations.remove(this.random.m_188503_(i));
            if (this.buildTunnelFromRoom(lobby, tunnel, rotation, direction = rotation.m_55954_(Direction.SOUTH), origin)) {
                longestTunnel = tunnel;
                break;
            }
            if (longestTunnel != null && tunnel.size() <= longestTunnel.size()) continue;
            longestTunnel = tunnel;
        }
        this.nodes.addAll(longestTunnel);
    }

    public boolean buildTunnelFromRoom(StructurePiece connectedRoom, List<StructurePiece> list, Rotation rotation, Direction direction, BlockPos origin) {
        BlockPos pos;
        StructureTemplate template = this.manager.m_230359_(new ResourceLocation("aether", "bronze_dungeon/entrance"));
        BlockPos startPos = BlockLogicUtil.tunnelFromEvenSquareRoom(connectedRoom.m_73547_(), direction, template.m_163801_().m_123341_());
        BronzeDungeonRoom entrance = new BronzeDungeonRoom(this.manager, "entrance", startPos, rotation);
        list.add((StructurePiece)entrance);
        startPos = startPos.m_121945_(direction);
        int length = template.m_163801_().m_123343_();
        boolean noOverlap = false;
        boolean reachedAir = false;
        int i = 0;
        do {
            pos = startPos.m_5484_(direction, i);
            BronzeTunnel tunnel = new BronzeTunnel(this.manager, "end_corridor", pos, rotation);
            StructurePiece col = null;
            for (StructurePiece piece : this.nodes) {
                if (piece == null || piece == connectedRoom || !piece.m_73547_().m_71049_(tunnel.m_73547_())) continue;
                col = piece;
                break;
            }
            if (col != null) break;
            noOverlap = true;
            list.add((StructurePiece)tunnel);
            connectedRoom = tunnel;
            i += length;
            if (!this.checkForAirAtPos(pos.m_123341_(), pos.m_123342_(), pos.m_123343_()) || !this.checkForAirAtPos(pos.m_123341_(), tunnel.m_73547_().m_162400_(), pos.m_123343_())) continue;
            reachedAir = true;
            break;
        } while (Math.abs(origin.m_123341_() - pos.m_123341_()) < 100 && Math.abs(origin.m_123343_() - pos.m_123343_()) < 100);
        return noOverlap && reachedAir;
    }

    public void populatePiecesBuilder(StructurePiecesBuilder builder) {
        StructurePiece bossRoom = this.nodes.remove(0);
        this.nodes.forEach(arg_0 -> ((StructurePiecesBuilder)builder).m_142679_(arg_0));
        this.edges.values().forEach(map -> map.values().forEach(connection -> builder.m_142679_(connection.hallway)));
        builder.m_142679_(bossRoom);
    }

    private boolean hasConnection(StructurePiece node, Direction direction) {
        Map<Direction, Connection> map = this.edges.get(node);
        return map != null && map.containsKey(direction);
    }

    private boolean checkForAirAtPos(int x, int y, int z) {
        NoiseColumn column = this.context.f_226622_().m_214184_(x, z, this.context.f_226629_(), this.context.f_226624_());
        return column.m_183556_(y).m_60795_();
    }

    private boolean isCloseToCenter(ChunkPos chunkPos, BlockPos pos) {
        ChunkPos currentChunk = new ChunkPos(pos);
        return chunkPos.m_45594_(currentChunk) <= 3;
    }

    private boolean isCoveredAtPos(BoundingBox room) {
        ChunkGenerator chunkGenerator = this.context.f_226622_();
        LevelHeightAccessor heightAccessor = this.context.f_226629_();
        RandomState randomState = this.context.f_226624_();
        int minX = room.m_162395_() - 1;
        int minZ = room.m_162398_() - 1;
        int maxX = room.m_162399_() + 1;
        int maxZ = room.m_162401_() + 1;
        NoiseColumn[] columns = new NoiseColumn[]{chunkGenerator.m_214184_(minX, minZ, heightAccessor, randomState), chunkGenerator.m_214184_(minX, maxZ, heightAccessor, randomState), chunkGenerator.m_214184_(maxX, minZ, heightAccessor, randomState), chunkGenerator.m_214184_(maxX, maxZ, heightAccessor, randomState)};
        return BronzeDungeonBuilder.isSolidInColumns(columns, room.m_162396_() - 1, room.m_162400_() + 1);
    }

    @Nullable
    private Rotation getBossRoomRotation(BlockPos minPos, BlockPos maxPos) {
        StructureTemplate template = this.context.f_226625_().m_230359_(new ResourceLocation("aether", "bronze_dungeon/chest_room"));
        WorldgenRandom random = this.context.f_226626_();
        BoundingBox bossBox = new BoundingBox(minPos.m_123341_(), minPos.m_123342_() + 1, minPos.m_123343_(), maxPos.m_123341_(), maxPos.m_123342_(), maxPos.m_123343_());
        for (Rotation rotation : Rotation.m_221992_((RandomSource)random)) {
            Direction direction = rotation.m_55954_(Direction.SOUTH);
            BlockPos.MutableBlockPos neighbor = BlockLogicUtil.tunnelFromEvenSquareRoom(bossBox, direction, this.nodeWidth).m_122032_();
            if (!this.isCoveredAtPos(template.m_74598_((BlockPos)(neighbor = neighbor.m_122184_(direction.m_122429_() * (this.edgeLength + bossBox.m_71056_()), 0, direction.m_122431_() * (this.edgeLength + bossBox.m_71058_()))), rotation, BlockPos.f_121853_, Mirror.NONE))) continue;
            return rotation;
        }
        return null;
    }

    private static boolean isSolidInColumns(NoiseColumn[] columns, int minY, int maxY) {
        for (NoiseColumn column : columns) {
            for (int y = minY; y <= maxY; ++y) {
                if (!column.m_183556_(y).m_60795_() && !column.m_183556_(y).m_204336_(AetherTags.Blocks.NON_BRONZE_DUNGEON_SPAWNABLE)) continue;
                return false;
            }
        }
        return true;
    }

    private class Connection {
        public final StructurePiece start;
        public final StructurePiece end;
        public final StructurePiece hallway;

        public Connection(StructurePiece start, StructurePiece end, StructurePiece hallway, Direction direction) {
            this.start = start;
            this.end = end;
            this.hallway = hallway;
            BronzeDungeonBuilder.this.edges.computeIfAbsent(start, piece -> new HashMap()).put(direction, this);
        }

        public StructurePiece endPiece() {
            return this.end;
        }
    }
}

