/*
 * Decompiled with CFR 0.152.
 */
package com.craisinlord.integrated_api.misc.maptrades;

import com.craisinlord.integrated_api.IntegratedAPI;
import com.craisinlord.integrated_api.events.RegisterVillagerTradesEvent;
import com.craisinlord.integrated_api.events.RegisterWanderingTradesEvent;
import com.craisinlord.integrated_api.misc.maptrades.StructureMapManager;
import com.craisinlord.integrated_api.misc.maptrades.StructureSpecificMaps;
import com.craisinlord.integrated_api.misc.maptrades.VillagerMapObj;
import com.craisinlord.integrated_api.misc.maptrades.WanderingTraderMapObj;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.saveddata.maps.MapDecoration;

public final class StructureMapTradesEvents {
    private StructureMapTradesEvents() {
    }

    public static void addVillagerTrades(RegisterVillagerTradesEvent event) {
        ResourceLocation currentVillager = BuiltInRegistries.f_256735_.m_7981_((Object)event.type());
        if (currentVillager != null && StructureMapManager.STRUCTURE_MAP_MANAGER.VILLAGER_MAP_TRADES.containsKey(currentVillager.toString())) {
            for (VillagerMapObj mapTrade : StructureMapManager.STRUCTURE_MAP_MANAGER.VILLAGER_MAP_TRADES.get(currentVillager.toString())) {
                MapDecoration.Type icon;
                try {
                    icon = MapDecoration.Type.valueOf((String)mapTrade.mapIcon.toUpperCase(Locale.ROOT));
                }
                catch (Exception e) {
                    IntegratedAPI.LOGGER.error((Object)e);
                    icon = MapDecoration.Type.MANSION;
                }
                event.addTrade(mapTrade.tradeLevel, new StructureSpecificMaps.TreasureMapForEmeralds(mapTrade.emeraldsRequired, mapTrade.structure, mapTrade.mapName, icon, mapTrade.tradesAllowed, mapTrade.xpReward, mapTrade.spawnRegionSearchRadius));
            }
        }
    }

    public static void addWanderingTrades(RegisterWanderingTradesEvent event) {
        for (Map.Entry<WanderingTraderMapObj.TRADE_TYPE, List<WanderingTraderMapObj>> tradeEntry : StructureMapManager.STRUCTURE_MAP_MANAGER.WANDERING_TRADER_MAP_TRADES.entrySet()) {
            for (WanderingTraderMapObj mapTrade : tradeEntry.getValue()) {
                MapDecoration.Type icon;
                try {
                    icon = MapDecoration.Type.valueOf((String)mapTrade.mapIcon.toUpperCase(Locale.ROOT));
                }
                catch (Exception e) {
                    IntegratedAPI.LOGGER.error((Object)e);
                    icon = MapDecoration.Type.MANSION;
                }
                if (tradeEntry.getKey() == WanderingTraderMapObj.TRADE_TYPE.RARE) {
                    event.addRareTrade(new StructureSpecificMaps.TreasureMapForEmeralds(mapTrade.emeraldsRequired, mapTrade.structure, mapTrade.mapName, icon, mapTrade.tradesAllowed, mapTrade.xpReward, mapTrade.spawnRegionSearchRadius));
                    continue;
                }
                if (tradeEntry.getKey() != WanderingTraderMapObj.TRADE_TYPE.COMMON) continue;
                event.addRareTrade(new StructureSpecificMaps.TreasureMapForEmeralds(mapTrade.emeraldsRequired, mapTrade.structure, mapTrade.mapName, icon, mapTrade.tradesAllowed, mapTrade.xpReward, mapTrade.spawnRegionSearchRadius));
            }
        }
    }
}

