/*
 * Decompiled with CFR 0.152.
 */
package com.craisinlord.integrated_api.world.structures;

import com.craisinlord.integrated_api.modinit.IAStructures;
import com.craisinlord.integrated_api.utils.GeneralUtils;
import com.craisinlord.integrated_api.world.structures.JigsawStructure;
import com.google.common.collect.Maps;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.heightproviders.HeightProvider;
import net.minecraft.world.level.levelgen.structure.PoolElementStructurePiece;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;

public class NetherJigsawStructure
extends JigsawStructure {
    public static final Codec<NetherJigsawStructure> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)NetherJigsawStructure.m_226567_((RecordCodecBuilder.Instance)instance), (App)StructureTemplatePool.f_210555_.fieldOf("start_pool").forGetter(structure -> structure.startPool), (App)Codec.intRange((int)0, (int)30).fieldOf("size").forGetter(structure -> structure.size), (App)Codec.INT.optionalFieldOf("min_y_allowed").forGetter(structure -> structure.minYAllowed), (App)Codec.INT.optionalFieldOf("max_y_allowed").forGetter(structure -> structure.maxYAllowed), (App)Codec.intRange((int)1, (int)1000).optionalFieldOf("allowed_y_range_from_start").forGetter(structure -> structure.allowedYRangeFromStart), (App)HeightProvider.f_161970_.fieldOf("start_height").forGetter(structure -> structure.startHeight), (App)Codec.BOOL.fieldOf("cannot_spawn_in_liquid").orElse((Object)false).forGetter(structure -> structure.cannotSpawnInLiquid), (App)Codec.intRange((int)1, (int)100).optionalFieldOf("valid_biome_radius_check").forGetter(structure -> structure.biomeRadius), (App)Codec.intRange((int)1, (int)128).optionalFieldOf("max_distance_from_center").forGetter(structure -> structure.maxDistanceFromCenter), (App)Codec.intRange((int)0, (int)100).optionalFieldOf("ledge_offset_y").forGetter(structure -> structure.ledgeOffsetY), (App)StringRepresentable.m_216439_(LAND_SEARCH_DIRECTION::values).fieldOf("land_search_direction").forGetter(structure -> structure.searchDirection), (App)Codec.BOOL.fieldOf("use_bounding_box_hack").orElse((Object)false).forGetter(structure -> structure.useBoundingBoxHack), (App)Codec.BOOL.fieldOf("rotation_fixed").orElse((Object)false).forGetter(structure -> structure.rotationFixed)).apply((Applicative)instance, NetherJigsawStructure::new));
    public final Optional<Integer> ledgeOffsetY;
    public final LAND_SEARCH_DIRECTION searchDirection;

    public NetherJigsawStructure(Structure.StructureSettings config, Holder<StructureTemplatePool> startPool, int size, Optional<Integer> minYAllowed, Optional<Integer> maxYAllowed, Optional<Integer> allowedYRangeFromStart, HeightProvider startHeight, boolean cannotSpawnInLiquid, Optional<Integer> biomeRadius, Optional<Integer> maxDistanceFromCenter, Optional<Integer> ledgeOffsetY, LAND_SEARCH_DIRECTION searchDirection, boolean useBoundingBoxHack, boolean rotationFixed) {
        super(config, startPool, size, minYAllowed, maxYAllowed, allowedYRangeFromStart, startHeight, Optional.empty(), cannotSpawnInLiquid, Optional.empty(), Optional.empty(), biomeRadius, maxDistanceFromCenter, Optional.empty(), rotationFixed, useBoundingBoxHack);
        this.ledgeOffsetY = ledgeOffsetY;
        this.searchDirection = searchDirection;
    }

    @Override
    protected void postLayoutAdjustments(StructurePiecesBuilder structurePiecesBuilder, Structure.GenerationContext context, int offsetY, BlockPos blockpos, int topClipOff, int bottomClipOff, List<PoolElementStructurePiece> pieces) {
        GeneralUtils.centerAllPieces(blockpos, pieces);
        WorldgenRandom random = new WorldgenRandom((RandomSource)new LegacyRandomSource(0L));
        random.m_190068_(context.f_226627_(), context.f_226628_().f_45578_, context.f_226628_().f_45579_);
        BlockPos placementPos = this.searchDirection == LAND_SEARCH_DIRECTION.HIGHEST_LAND ? GeneralUtils.getHighestLand(context.f_226622_(), context.f_226624_(), structurePiecesBuilder.m_192798_(), context.f_226629_(), !this.cannotSpawnInLiquid) : GeneralUtils.getLowestLand(context.f_226622_(), context.f_226624_(), structurePiecesBuilder.m_192798_(), context.f_226629_(), !this.cannotSpawnInLiquid);
        if (placementPos.m_123342_() >= GeneralUtils.getMaxTerrainLimit(context.f_226622_()) || placementPos.m_123342_() <= context.f_226622_().m_6337_() + 1) {
            int yDiff = context.f_226622_().m_6337_() + this.ledgeOffsetY.orElse(0) - pieces.get(0).m_73547_().m_162396_();
            pieces.forEach(piece -> piece.m_6324_(0, yDiff, 0));
        } else {
            int yDiff = placementPos.m_123342_() + this.ledgeOffsetY.orElse(0) - pieces.get(0).m_73547_().m_162396_();
            pieces.forEach(piece -> piece.m_6324_(0, yDiff, 0));
        }
        pieces.forEach(piece -> piece.m_6324_(0, offsetY, 0));
    }

    @Override
    public StructureType<?> m_213658_() {
        return IAStructures.NETHER_JIGSAW_STRUCTURE.get();
    }

    public static enum LAND_SEARCH_DIRECTION implements StringRepresentable
    {
        HIGHEST_LAND("HIGHEST_LAND"),
        LOWEST_LAND("LOWEST_LAND");

        private final String name;
        private static final Map<String, LAND_SEARCH_DIRECTION> BY_NAME;

        private LAND_SEARCH_DIRECTION(String name) {
            this.name = name;
        }

        public static LAND_SEARCH_DIRECTION byName(String name) {
            return BY_NAME.get(name.toUpperCase(Locale.ROOT));
        }

        public String m_7912_() {
            return this.name;
        }

        static {
            BY_NAME = (Map)Util.m_137469_((Object)Maps.newHashMap(), hashMap -> {
                LAND_SEARCH_DIRECTION[] var1;
                for (LAND_SEARCH_DIRECTION type : var1 = LAND_SEARCH_DIRECTION.values()) {
                    hashMap.put(type.name, type);
                }
            });
        }
    }
}

